import PageEditorStates from "./PageEditorStates.js";
import ImageManagerState from "../../image-manager/ImageManagerState.js";
import ContentChangedHandler from "../ContentChangedHandler.js";
import PageEditor from "./PageEditor.js";

class FeaturedImage{

	featuredImage = document.querySelector("#featured-image");
	setButton = document.querySelector("#set-featured-image-button");
	clearButton = document.querySelector("#clear-featured-image-button");

	constructor(){

		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		if (this.featuredImage !== null){

			this.setButton.addEventListener("click", () => {
				this.setImageButtonClicked();
			});

			this.featuredImage.addEventListener("click", () => {
				this.setImageButtonClicked();
			});

			this.clearButton.addEventListener("click", () => {
				this.clearFeaturedImage();
			});
		}
	}

	/**
	 * When the set featured image button is clicked
	 */
	async setImageButtonClicked(){
		if (PageEditor.imageManager !== null) {
			const imageManager = PageEditor.imageManager;
			// Open the image manager in select mode
			imageManager.imageManagerState.setImageMode(imageManager.imageManagerState.IMAGE_MODES.SELECT);
			imageManager.windowManager.show(imageManager.windowManager.constructor.WINDOWS.MAIN);
			this.onImageManagerImageSelected(await imageManager.imagesChosen);
		}
	}

	/**
	 * When an image is selected from the image manager
	 * @param {?ImageComponent[]} imageComponentsChosen
	 */
	onImageManagerImageSelected(imageComponentsChosen){
		// Only use the first one
		if (imageComponentsChosen !== null){
			if (imageComponentsChosen.length > 0){
				const firstImageComponent = imageComponentsChosen[0];

				// Some images don't have thumbs
				let thumbURI = firstImageComponent.thumbURI;
				if (thumbURI === null){
					thumbURI = firstImageComponent.uri;
				}

				this.featuredImage.setAttribute("src", thumbURI);
				document.querySelector("#featured-image-input").value = firstImageComponent.uri;
				document.querySelector("#featured-image-thumb-input").value = thumbURI;
			}
		}
		PageEditor.imageManager.windowManager.closeImageManager();
		ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
	}

	clearFeaturedImage(){
		this.featuredImage.setAttribute("src", "");
		document.querySelector("#featured-image-input").value = "";
		document.querySelector("#featured-image-thumb-input").value = "";
		ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
	}
}

export default (new FeaturedImage);
