import PageEditorStates from "./PageEditorStates.js";
import NewPageModal from "./modals/NewPageModal.js";
import Endpoints from "../../Endpoints.js";
import PageCategoryButton from "./components/PageCategoryButton.js";
import PageButton from "./components/PageButton.js";
import PageList from "./components/PageList.js";

/**
* Handles the page editor page loading
* and rendering them into the sidebar
*/
class SidebarPageLoader{

	static currentPageListCategoryName = "";
	static loader = document.querySelector("#pages-categories-loader");
	static categoriesMainContainer = document.querySelector("#pages-categories-main");

	constructor(){
		this.loadPages();
	}

	/**
	 * Hides the loading UI
	 */
	hideLoader(){
		SidebarPageLoader.loader.style.display = "none";
	}

	/**
	 * Shows the container of the category buttons. Typically, called after hideLoader()
	 */
	showCategoryButtonsContainer(){
		SidebarPageLoader.categoriesMainContainer.style.display = "block";
	}

	/**
	* Fetch all the pages to be passed to the renderer
	*/
	async loadPages(){
		const response = await fetch(`/uplift/page-editor/pages`, {
			cache:"no-cache",
			credentials:"same-origin"
		});

		const data = await response.json();
		if (data.status === 1){
			/**
			 * @type {{pages:{
			 * General:Object[],
			 * City:Object[],
			 * Blog:Object[],
			 * Project:Object[],
			 * Service:Object[],
			 * }}}
			 */
			const pages = data.pages;

			for (let categoryName of Object.keys(pages)){
				const categoryButton = PageCategoryButton.getButtonForPageType(categoryName);

				// The categoryButton will be null if the user doesn't have permission to edit/view to category
				if(categoryButton === null) {
					// Skips the category entirely
					continue;
				}

				const pageList = PageList.getByCategoryName(categoryName);

				/** @type {{id: number, pageName: string}[]} */
				const pagesArray = pages[categoryName];

				categoryButton.numPagesSpan.textContent = String(pagesArray.length);

				// Load all pages in this category
				for (const pageData of pagesArray){
					const pageButton = new PageButton(
						pageData.id,
						pageData.pageName,
					);
					pageList.dom.append(pageButton.dom);
				}
			}
		}
	}
}

export default SidebarPageLoader;
