import ArticleCategoryManager from "../ArticleCategoryManager.js";

class ArticleCategoryPageDataLabel{

	/** @type {ArticleCategoryPageDataLabel[]} */
	static rows = [];

	static clearAll(){
		for (const component of ArticleCategoryPageDataLabel.rows){
			component.dom.remove();
		}

		ArticleCategoryPageDataLabel.rows = [];
	}

	static removeRowByID(categoryID){
		let indexToSplice;
		for (const componentIndex in ArticleCategoryPageDataLabel.rows){
			const component = ArticleCategoryPageDataLabel.rows[componentIndex];
			if (component.categoryID === categoryID){
				indexToSplice = componentIndex;
				component.dom.remove();
				break;
			}
		}

		ArticleCategoryPageDataLabel.rows.splice(indexToSplice, 1);
	}

	/**
	 * @param {int} categoryID
	 * @param {string} label
	 */
	constructor(categoryID, label) {
		this.categoryID = categoryID;
		this.label = label;
		this.dom = this.getDOM();
		ArticleCategoryManager.labelsContainer.append(this.dom);

		this.constructor.rows.push(this);
	}

	getDOM(){
		const template = document.createElement("div");
		template.classList.add("article-category-page-data-label");
		template.innerHTML = `
			<i class="bi bi-tag-fill"></i>
		    <span>${this.label}</span>
		`;

		return template;
	}
}

export default ArticleCategoryPageDataLabel;