import ContentChangedHandler from "../../ContentChangedHandler.js";
import PageEditorStates from "../PageEditorStates.js";
import BreadcrumbsManager from "../BreadcrumbsManager.js";

class Breadcrumb{

	static crumbsContainer = document.querySelector("#crumbs-container");
	static nextIndex = 1;

	label;
	labelDOMInput;
	uri;
	uriDOMInput;
	dom;
	#internalIndex;

	/**
	 *
	 * @param {string} label
	 * @param {string} uri
	 */
	constructor(label, uri){
		this.#internalIndex = Breadcrumb.nextIndex++;
		this.label = label;
		this.uri = uri;
		this.dom = this.getDOM();
	}

	delete(){
		this.dom.remove();

		// Remove it from the breadcrumbs static array
		let indexToRemove = null;
		for (const index in BreadcrumbsManager.breadcrumbs){
			const crumb = BreadcrumbsManager.breadcrumbs[index];
			if (crumb.#internalIndex === this.#internalIndex){
				indexToRemove = index;
			}
		}

		BreadcrumbsManager.breadcrumbs.splice(indexToRemove, 1);
	}

	/**
	 * Prefills the breadcrumb with the current page name and URI
	 */
	prefill(){
		const currentPageName = document.querySelector("#page-name").value.trim();
		const currentPageRoute = document.querySelector("#page-url").value.trim();

		this.labelDOMInput.value = currentPageName;
		this.uriDOMInput.value = currentPageRoute
		this.uri = currentPageRoute;
		this.label = currentPageName;
	}

	/**
	 * @returns {HTMLDivElement}
	 */
	getDOM(){
		const template = document.createElement("div");
		template.classList.add("crumb");
		template.classList.add("mb-2");
		template.innerHTML = `
			<div class="me-2">
				<label>Crumb label</label>
				<div class="input-group">
					<span class="input-group-text"><i class="bi bi-input-cursor-text"></i></span>
					<input type="text" class="crumb-label form-control" placeholder="Label" value="${this.label}">
				</div>
			</div>
			<div>
				<label>Crumb URI</label>
				<div class="input-group">
					<span class="input-group-text"><i class="bi bi-input-cursor-text"></i></span>
					<input type="text" class="crumb-uri form-control" placeholder="URI" value="${this.uri}">
				</div>
			</div>
			<button type="button" class="square delete-button btn btn-danger btn-sm">
				<svg width="1rem" height="1rem" viewBox="0 0 16 16" class="bi bi-trash-fill" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
					<path fill-rule="evenodd" d="M2.5 1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1H3v9a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V4h.5a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H10a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1H2.5zm3 4a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zM8 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7A.5.5 0 0 1 8 5zm3 .5a.5.5 0 0 0-1 0v7a.5.5 0 0 0 1 0v-7z"/>
				</svg>
			</button>
			<button type="button" class="square prefill-crumb-button btn btn-primary btn-sm">
				<span>Prefill</span>
			</button>
		`;

		const labelInput = template.querySelector(".crumb-label");
		const uriInput = template.querySelector(".crumb-uri");
		const deleteButton = template.querySelector(".delete-button");
		const prefillButton = template.querySelector(".prefill-crumb-button");

		this.uriDOMInput = uriInput;
		this.labelDOMInput = labelInput;

		// Unsaved changes event
		labelInput.addEventListener("input", () => {
			this.label = labelInput.value;
			ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
		});

		// Unsaved changes event
		uriInput.addEventListener("input", () => {
			this.uri = uriInput.value;
			ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
		});

		// Delete crumb event
		deleteButton.addEventListener("click", () => {
			this.delete();
			ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
		});

		// Prefill button event
		prefillButton.addEventListener("click", () => {
			this.prefill();
			ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
		});

		// Add the new crumb to the crumbs container
		Breadcrumb.crumbsContainer.append(template);

		return template;
	}
}

export default Breadcrumb;