import PageList from "./PageList.js";
import SidebarPageLoader from "../SidebarPageLoader.js";

class PageCategoryButton{

	/** @type {PageCategoryButton[]} */
	static instances = [];

	button;
	pageType;

	/** @type {HTMLSpanElement} */
	numPagesSpan;

	/**
	 * @param {string} pageType
	 * @return {PageCategoryButton | null}
	 */
	static getButtonForPageType(pageType){
		for (const buttonInstance of PageCategoryButton.instances){
			if (pageType === buttonInstance.pageType){
				return buttonInstance;
			}
		}

		return null;
	}

	/**
	 *
	 * @param {HTMLButtonElement} button
	 */
	constructor(button){
		this.button = button;
		this.pageType = button.getAttribute("data-page-enum");
		this.numPagesSpan = button.querySelector(".num-pages");

		PageCategoryButton.instances.push(this);

		this.button.addEventListener("click", () => {
			this.onClick();
		});
	}

	onClick(){
		document.querySelector("#page-type-title-container .page-type-title").textContent = this.pageType;
		document.querySelector("#new-page-type").value = this.pageType;
		SidebarPageLoader.currentPageListCategoryName = this.pageType;
		SidebarPageLoader.categoriesMainContainer.style.display = "none";
		const list = PageList.getByCategoryName(this.pageType);
		list.show();
	}
}

export default PageCategoryButton;