import ProjectTagManager from "../ProjectTagManager.js";

class ProjectTagPageDataLabel{

	/** @type {ProjectTagPageDataLabel[]} */
	static rows = [];

	static clearAll(){
		for (const component of ProjectTagPageDataLabel.rows){
			component.dom.remove();
		}

		ProjectTagPageDataLabel.rows = [];
	}

	static removeRowByID(tagID){
		let indexToSplice;
		for (const componentIndex in ProjectTagPageDataLabel.rows){
			const component = ProjectTagPageDataLabel.rows[componentIndex];
			if (component.tagID === tagID){
				indexToSplice = componentIndex;
				component.dom.remove();
				break;
			}
		}

		ProjectTagPageDataLabel.rows.splice(indexToSplice, 1);
	}

	/**
	 * @param {int} tagID
	 * @param {string} label
	 */
	constructor(tagID, label) {
		this.tagID = tagID;
		this.label = label;
		this.dom = this.getDOM();
		ProjectTagManager.labelsContainer.append(this.dom);

		this.constructor.rows.push(this);
	}

	getDOM(){
		const template = document.createElement("div");
		template.classList.add("project-tag-page-data-label");
		template.innerHTML = `
			<i class="bi bi-tag-fill"></i>
		    <span>${this.label}</span>
		`;

		return template;
	}
}

export default ProjectTagPageDataLabel;