class RecentProjectsTagButton{

	/** @type {RecentProjectsTagButton[]} */
	static rows = [];

	/** @type {HTMLDivElement} */
	static container = document.querySelector("#recent-projects-tags-container");

	/**
	 * Removes all the DOM HTML of each button and then clears the static rows array
	 */
	static clearAll(){
		for (const component of RecentProjectsTagButton.rows){
			component.dom.remove();
		}

		RecentProjectsTagButton.rows = [];
	}

	/**
	 * @type {boolean} Whether this button is selected or not
	 */
	isSelected = false;

	constructor(tagID, tagName) {
		this.tagID = tagID;
		this.tagName = tagName;
		this.dom = this.getDOM();

		this.constructor.rows.push(this);
		this.constructor.container.append(this.dom);
	}

	toggleSelection(){
		if (this.isSelected){
			this.deselect();
		}else{
			this.select();
		}
	}

	select(){
		this.isSelected = true;
		this.dom.classList.remove("btn-outline-primary");
		this.dom.classList.add("btn-primary");
	}

	deselect(){
		this.isSelected = false;
		this.dom.classList.add("btn-outline-primary");
		this.dom.classList.remove("btn-primary");
	}

	getDOM(){
		const template = document.createElement("button");
		template.classList.add("recent-projects-tag-select-button");
		template.classList.add("btn");
		template.classList.add("btn-outline-primary");
		template.classList.add("btn-sm");
		template.setAttribute("type", "button");
		template.innerHTML = `
			<i class="bi bi-tag-fill"></i>
			<span>${this.tagName}</span>
		`;

		template.addEventListener("click", () => {
			this.toggleSelection();
		});

		return template;
	}

}

export default RecentProjectsTagButton;