import PageEditorStates from "../PageEditorStates.js";
import InsertGalleryModal from "../modals/InsertGalleryModal.js";

class FilterInsertGalleryModal{
	constructor(){
		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.form = document.querySelector("#insert-gallery-filter-form");
		this.textInput = document.querySelector("#gallery-filter-input");

		/** @property {bool} isSubmitting The current status of submission */
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});

		this.textInput.addEventListener("input", () => {
			InsertGalleryModal.filterByText(this.textInput.value.trim());
		});
	}

	/**
	* When the form is submitted
	*/
	async onSubmit(){
		InsertGalleryModal.filterByText(this.textInput.value.trim());
	}
}

export default (new FilterInsertGalleryModal);
