import GetPagesShortcodeButton from "../shortcode-buttons/GetPages.js";
import PageEditorStates from "../PageEditorStates.js";
import GetPagesCheckboxes from "../components/GetPagesCheckboxes.js";

class GetPagesForm{
	constructor(){
		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.form = document.querySelector("#get-pages-form");
		this.submitButton = document.querySelector(`#submit-get-pages-form-button`);
		this.errorContainer = this.form.querySelector(".submit-error");

		/** @property {bool} isSubmitting The current status of submission */
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	/**
	 * When the form is submitted
	 */
	async onSubmit(){
		const fData = new FormData(this.form);
		const shortcodeFile = document.querySelector("#get-pages-shortcode-file").value;
		const pages = fData.getAll("pages[]");

		if (this.isSubmitting){
			return;
		}

		// Show the submit button as disabled
		this.submitButton.classList.add("disabled");
		this.errorContainer.style.display = "none";

		this.onSuccess(shortcodeFile, pages);
	}

	/**
	 * When the form succeeds without error
	 */
	onSuccess(shortcodeFile, pages){
		this.isSubmitting = false;
		this.submitButton.classList.remove("disabled");

		// Inject the shortcode with the known parameters
		GetPagesShortcodeButton.injectShortcode('{{ get-pages page-ids="['+ pages + ']" shortcode-file="'+ shortcodeFile + '" }}');
	}

	/**
	 * A readable error happened on the server in the JSON response.
	 * (A status of -1 was read)
	 * @param {string} err
	 */
	onFormattedError(err){
		const errorContainer = this.form.querySelector(".submit-error");
		const submitButton = this.form.querySelector(`button[type="submit"]`);

		this.isSubmitting = false;
		submitButton.classList.remove("disabled");
		errorContainer.textContent = err;
		errorContainer.style.display = "block";
	}
}

export default (new GetPagesForm);
