import NewBlogCategoryModal from "../modals/NewBlogCategoryModal.js";
import ArticleCategoryRow from "../components/ArticleCategoryRow.js";
import PageEditorStates from "../PageEditorStates.js";

class NewBlogCategoryForm{
	constructor(){
		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.form = document.querySelector("#new-article-category-form");

		/** @type {HTMLInputElement} */
		this.newCategoryNameInput = document.querySelector("#new-article-category-name");

		/** @property {bool} isSubmitting The current status of submission */
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	/**
	 * When the form is submitted
	 */
	async onSubmit(){
		const fData = new FormData(this.form);
		this.newCategoryNameInput.setAttribute("disabled", "true");
		const submitButton = this.form.querySelector(`button[type="submit"]`);
		const errorContainer = this.form.querySelector(".submit-error");

		if (this.isSubmitting){
			return;
		}

		// Show the submit button as disabled
		submitButton.classList.add("disabled");
		errorContainer.style.display = "none";

		const response = await fetch(`/uplift/page-editor/article-category`, {
			cache:"no-cache",
			method:"post",
			credentials:"same-origin",
			body:fData
		});

		/** @type {{status: int, error: ?string, newCategoryID: int, newCategoryName: string}} */
		const data = await response.json();

		if (data.status === 1){
			this.onSuccess(data.newCategoryID, data.newCategoryName);
		}else if (data.status === -1){
			this.onFormattedError(data.error);
		}

		this.newCategoryNameInput.removeAttribute("disabled");
	}

	/**
	 * When the form receives a success (status code 1) from
	 * the server
	 * @param {int} categoryID
	 * @param {string} categoryName
	*/
	onSuccess(categoryID, categoryName){
		const submitButton = this.form.querySelector(`button[type="submit"]`);
		this.isSubmitting = false;
		submitButton.classList.remove("disabled");
		NewBlogCategoryModal.hideModal();
		this.form.reset();

		new ArticleCategoryRow(categoryID, categoryName, false);
	}

	/**
	* A readable error happened on the server in the JSON response.
	* (A status of -1 was read)
	* @param {string} err
	*/
	onFormattedError(err){
		const errorContainer = this.form.querySelector(".submit-error");
		const submitButton = this.form.querySelector(`button[type="submit"]`);

		this.isSubmitting = false;
		submitButton.classList.remove("disabled");
		errorContainer.textContent = err;
		errorContainer.style.display = "block";
	}
}

export default (new NewBlogCategoryForm);
