import PageEditorStates from "../PageEditorStates.js";
import ArticleCategoryRow from "../components/ArticleCategoryRow.js";
import BSModal from "../../../_external/bootstrap/modal.js";

class BlogCategoryManageModal{

	modal = document.querySelector("#manage-blog-categories");
	enableNewCategoryForm = document.querySelector("#new-article-category-form");
	cancelNewCategoryFormButton = document.querySelector("#cancel-new-article-category-button");
	enableNewCategoryFormButton = document.querySelector("#enable-new-article-category-form");
	enableNewCategoryFormButtonContainer = document.querySelector("#enable-new-article-category-button-container");

	constructor(){

		if (this.modal !== null) {

			// Ignore logic in this code for revision views
			if (PageEditorStates.viewType === "REVISION") {
				return;
			}

			this.bsModal = new BSModal(this.modal);

			// Preload the article category selection rows
			let systemArticleCategories = [];
			try {
				systemArticleCategories = JSON.parse(document.querySelector("#init-all-system-article-categories").value);
			} catch (e) {
			}

			// Preload the already-linked page-article categories
			let preloadedPageArticleCategories = [];
			try {
				preloadedPageArticleCategories = JSON.parse(document.querySelector("#init-page-linked-article-categories").value);
			} catch (e) {
			}

			// Fix overlapping imports not completing and accessing ArticleCategoryRow before import finishes
			setTimeout(() => {
				for (const systemArticleCategoryRow of systemArticleCategories) {
					let isSelected = false;
					for (const pageArticleCategory of preloadedPageArticleCategories) {
						if (systemArticleCategoryRow.id === pageArticleCategory.articleCategoryID) {
							isSelected = true;
							break;
						}
					}

					new ArticleCategoryRow(systemArticleCategoryRow.id, systemArticleCategoryRow.name, isSelected);
				}
			}, 1);

			this.enableNewCategoryFormButton.addEventListener("click", () => {
				this.showNewArticleCategoryForm();
			});

			this.cancelNewCategoryFormButton.addEventListener("click", () => {
				this.hideNewArticleCategoryForm();
			});
		}
	}

	showNewArticleCategoryForm(){
		this.enableNewCategoryForm.style.display = "block";
		this.enableNewCategoryFormButtonContainer.style.display = "none";
	}

	hideNewArticleCategoryForm(){
		this.enableNewCategoryForm.style.display = "none";
		this.enableNewCategoryFormButtonContainer.style.display = "block";
	}

	/**
	* Forces the modal to be shown
	*/
	showModal(){
		this.bsModal.show();
	}

	/**
	* Forces the modal to be hidden
	*/
	hideModal(){
		this.bsModal.hide();
	}
}

export default new BlogCategoryManageModal();
