import PageEditorStates from "../PageEditorStates.js";
import BSModal from "../../../_external/bootstrap/modal.js";
import BlogCategoryManageModal from "./BlogCategoryManageModal.js";

class BlogCategoryRenameModal{
	constructor(){

		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.modal = document.querySelector("#blog-category-rename-modal");
		this.bsModal = new BSModal(this.modal);

		/** @type {HTMLInputElement} */
		this.categoryIDInput = this.modal.querySelector("#blog-category-rename-id");

		/** @type {HTMLInputElement} */
		this.renameInput = this.modal.querySelector("#rename-article-category-input");

		this.modal.addEventListener("hidden.bs.modal", () => {
			BlogCategoryManageModal.showModal();
		});
	}

	/**
	* Forces the modal to be shown
	*/
	showModal(){
		this.bsModal.show();
	}

	/**
	* Forces the modal to be hidden
	*/
	hideModal(){
		this.bsModal.hide();
	}
}

export default new BlogCategoryRenameModal();
