import BSModal from "../../../_external/bootstrap/modal.js";
import PageEditorStates from "../PageEditorStates.js";
import GetPagesCheckboxes from "../components/GetPagesCheckboxes.js";
import Scheduler from "../../../utils/Scheduler.js";

class GetPagesModal{

	isProcessing = false;
	loader = document.querySelector("#get-pages-page-loader");
	noBlogPagesMessage = document.querySelector("#get-pages-no-blog-pages");
	noCityPagesMessage = document.querySelector("#get-pages-no-city-pages");
	noGeneralPagesMessage = document.querySelector("#get-pages-no-general-pages");
	noProjectPagesMessage = document.querySelector("#get-pages-no-project-pages");
	noServicePagesMessage = document.querySelector("#get-pages-no-service-pages");

	constructor(){

		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.modal = document.querySelector("#get-pages-modal");
		this.bsModal = new BSModal(this.modal);
		this.modal.addEventListener("show.bs.modal", () => {
			this.fetchPages();
		})
	}

	/**
	 * Forces the modal to be shown
	 */
	showModal(){
		this.bsModal.show();
	}

	/**
	 * Forces the modal to be hidden
	 */
	hideModal(){
		this.bsModal.hide();
	}

	async fetchPages(){

		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.loader.style.display = null;
		GetPagesCheckboxes.clearAll();

		const response = await fetch(`/uplift/page-editor/pages`, {
			method:"GET",
			cache:"no-cache",
			credentials:"same-origin"
		});

		await Scheduler.wait(350);

		let data;
		try{
			/** @type {{status: int, error: ?string, categories: Object[]}} **/
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			return;
		}

		if (data.status === 1){
			if(data.pages.Blog.length > 0) {
				this.noBlogPagesMessage.style.display = "none";

				for (const page of data.pages.Blog) {
					new GetPagesCheckboxes(page.id, page.pageName, "Blog");
				}
			} else {
				this.noBlogPagesMessage.style.display = null;
			}

			if(data.pages.City.length > 0) {
				this.noCityPagesMessage.style.display = "none";

				for (const page of data.pages.City) {
					new GetPagesCheckboxes(page.id, page.pageName, "City");
				}
			} else {
				this.noCityPagesMessage.style.display = null;
			}

			if(data.pages.General.length > 0) {
				this.noGeneralPagesMessage.style.display = "none";

				for (const page of data.pages.General) {
					new GetPagesCheckboxes(page.id, page.pageName, "General");
				}
			} else {
				this.noGeneralPagesMessage.style.display = null;
			}

			if(data.pages.Project.length > 0) {
				this.noProjectPagesMessage.style.display = "none";

				for (const page of data.pages.Project) {
					new GetPagesCheckboxes(page.id, page.pageName, "Project");
				}
			} else {
				this.noProjectPagesMessage.style.display = null;
			}

			if(data.pages.Service.length > 0) {
				this.noServicePagesMessage.style.display = "none";

				for (const page of data.pages.Service) {
					new GetPagesCheckboxes(page.id, page.pageName, "Service");
				}
			} else {
				this.noServicePagesMessage.style.display = null;
			}

		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
		this.loader.style.display = "none";
	}

}

export default (new GetPagesModal);
