import BSModal from "../../../_external/bootstrap/modal.js";
import PageEditorStates from "../PageEditorStates.js";

class IPPReelModal{
	constructor(){

		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.modal = document.querySelector("#ipp-reel-modal");
		this.bsModal = new BSModal(this.modal);

		this.inclusionButtons = this.modal.querySelectorAll(".ipp-reel-tag-include-button");
		this.exclusionButtons = this.modal.querySelectorAll(".ipp-reel-tag-exclude-button");

		for (let button of this.inclusionButtons){
			button.addEventListener("click", () => {
				this.onIncludeTagButtonClicked(button);
			});
		}

		for (let button of this.exclusionButtons){
			button.addEventListener("click", () => {
				this.onExcludeTagButtonClicked(button);
			});
		}
	}

	/**
	* Forces the modal to be shown
	*/
	showModal(){
		this.bsModal.show();
	}

	/**
	* Forces the modal to be hidden
	*/
	hideModal(){
		this.bsModal.hide();
	}

	/**
	* An include-project tag button was clicked
	* @param {HTMLButtonElement} button
	*/
	onIncludeTagButtonClicked(button){
		if (!button.classList.contains("selected")){
			button.classList.add("btn-primary");
			button.classList.add("selected");
			button.classList.remove("btn-outline-primary");
		}else{
			button.classList.add("btn-outline-primary");
			button.classList.remove("selected");
			button.classList.remove("btn-primary");
		}
	}

	/**
	* An exclude-project tag button was clicked
	* @param {HTMLButtonElement} button
	*/
	onExcludeTagButtonClicked(button){
		if (!button.classList.contains("selected")){
			button.classList.add("btn-danger");
			button.classList.add("selected");
			button.classList.remove("btn-outline-danger");
		}else{
			button.classList.add("btn-outline-danger");
			button.classList.remove("selected");
			button.classList.remove("btn-danger");
		}
	}
}

export default (new IPPReelModal);
