import BSModal from "../../../_external/bootstrap/modal.js";
import PageEditorStates from "../PageEditorStates.js";
import Scheduler from "../../../utils/Scheduler.js";
import RecentProjectsTagButton from "../components/RecentProjectsTagButton.js";

class RecentProjectsModal{

	isProcessing = false;
	loader = document.querySelector("#recent-projects-tags-loader");
	noTagsMessage = document.querySelector("#recent-projects-no-tags-categories");

	constructor(){
		// Ignore logic in this code for revision views
		if (PageEditorStates.viewType === "REVISION"){
			return;
		}

		this.modal = document.querySelector("#recent-projects-modal");
		this.bsModal = new BSModal(this.modal);
		this.modal.addEventListener("show.bs.modal", () => {
			this.fetchArticleCategories();
		})
	}

	/**
	* Forces the modal to be shown
	*/
	showModal(){
		this.bsModal.show();
	}

	/**
	* Forces the modal to be hidden
	*/
	hideModal(){
		this.bsModal.hide();
	}

	async fetchArticleCategories(){

		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.loader.style.display = null;
		RecentProjectsTagButton.clearAll();

		const response = await fetch(`/uplift/page-editor/project-tags`, {
			method:"GET",
			cache:"no-cache",
			credentials:"same-origin"
		});

		await Scheduler.wait(550);

		let data;
		try{
			/** @type {{status: int, error: ?string, tags: Object[]}} **/
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			return;
		}

		if (data.status === 1){
			if (data.tags.length > 0) {
				this.noTagsMessage.style.display = "none";

				data.tags.sort((a, b) => a.label.localeCompare(b.label));

				for (/** @type{{id: int, label: string}} */ const tag of data.tags) {
					new RecentProjectsTagButton(tag.id, tag.label);
				}
			}else{
				this.noTagsMessage.style.display = null;
			}
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
		this.loader.style.display = "none";
	}
}

export default (new RecentProjectsModal);
