import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";
import BlogReelModal from "../modals/BlogReelModal.js";

class BlogReelShortcodeButton{
	constructor(){
		if (PageEditorStates.viewType !== "REVISION"){
			this.button = document.querySelector("#article-reel-shortcode-button");

			this.button.addEventListener("click", () => {
				this.onButtonClicked();
			});
		}
	}

	/**
	* When one of the inner buttons inside the main shortcode
	* button is clicked
	*/
	onButtonClicked(){
		BlogReelModal.showModal();
	}

	/**
	* Usually called from the modal's form when it's submitted.
	* Will inject the shortcode into the current editor
	* @param {int} numArticlesPerPage
	* @param {int} numColumns
	* @param {string[]} includedCategoryIDs
	* @param {string[]} excludedCategoryIDs
	*/
	injectShortcode(numArticlesPerPage, numColumns, includedCategoryIDs, excludedCategoryIDs){
		includedCategoryIDs = JSON.stringify(includedCategoryIDs);
		excludedCategoryIDs = JSON.stringify(excludedCategoryIDs);
		const shortcodeText = `{{ get-articles articles-per-page="${numArticlesPerPage}" columns="${numColumns}" included-categories="${includedCategoryIDs}" excluded-categories="${excludedCategoryIDs}" }}`
		EditorWrapper.insertTextAtCursor(shortcodeText);
		BlogReelModal.hideModal();
		EditorWrapper.focusEditor();
	}
}

export default (new BlogReelShortcodeButton);
