import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";
import GetPagesModal from "../modals/GetPagesModal.js";

class GetPagesShortcodeButton{
	constructor(){
		if (PageEditorStates.viewingState !== ""){
			this.button = document.querySelector("#get-pages-shortcode-button");

			this.button.addEventListener("click", () => {
				this.onButtonClicked();
			});
		}
	}

	/**
	 * When one of the inner buttons inside the main shortcode
	 * button is clicked
	 * @param {Button} button HTML DOMNode
	 */
	onButtonClicked(button){
		GetPagesModal.showModal();
	}

	/**
	 * Usually called from the modal's form when it's submitted.
	 * Will inject the shortcode into the current editor
	 */
	injectShortcode(shortcodeText){
		EditorWrapper.insertTextAtCursor(shortcodeText);
		GetPagesModal.hideModal();
		EditorWrapper.focusEditor();
	}
}

export default (new GetPagesShortcodeButton);
