import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";

class PageCityShortcodeButton{

	button = document.querySelector("#page-city-shortcode-button");

	constructor(){
		if (PageEditorStates.viewType !== "REVISION"){
			if (this.button) {
				this.button.addEventListener("click", () => {
					this.onButtonClicked();
				});
			}
		}
	}

	/**
	* When the shortcode button is clicked
	*/
	onButtonClicked(){
		const shortcodeText = `{{ city-name map-safe="false" }}`;
		EditorWrapper.insertTextAtCursor(shortcodeText);
		EditorWrapper.focusEditor();
	}
}

export default (new PageCityShortcodeButton);
