import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";

class PageStateShortcodeButton{

	button = document.querySelector("#page-state-shortcode-button");

	constructor(){
		if (PageEditorStates.viewType !== "REVISION"){
			if (this.button){
				this.button.addEventListener("click", () => {
					this.onButtonClicked();
				});
			}
		}
	}

	/**
	* When the shortcode button is clicked
	*/
	onButtonClicked(){
		const shortcodeText = `{{ state-name map-safe="false" short-hand="false" }}`;
		EditorWrapper.insertTextAtCursor(shortcodeText);
		EditorWrapper.focusEditor();
	}
}

export default (new PageStateShortcodeButton);
