import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";

class PurePhoneNumbersShortcodeButton{
	/** @type {NodeList<HTMLButtonElement>} */
	buttons = document.querySelectorAll(".pure-company-phone-shortcode-button");

	constructor(){
		if (PageEditorStates.viewType === "STANDARD"){

			for (/** @type {HTMLButtonElement} */ const button of this.buttons){
				button.addEventListener("click", () => {
					this.onInnerButtonClicked(button);
				});
			}
		}
	}

	/**
	 * @param {HTMLButtonElement} button
	 */
	onInnerButtonClicked(button){
		const numberIndex = parseInt(button.getAttribute("number-index"));
		if (!isNaN(numberIndex)){
			const shortcodeText = `{{ phone-number which='${numberIndex}' pure-number='1' }}`;
			EditorWrapper.insertTextAtCursor(shortcodeText);
			EditorWrapper.focusEditor();
		}
	}
}

export default new PurePhoneNumbersShortcodeButton();
