import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";
import RecentArticlesModal from "../modals/RecentArticlesModal.js";

class RecentArticlesShortcodeButton{
	constructor(){
		if (PageEditorStates.viewType !== "REVISION"){
			this.button = document.querySelector("#recent-articles-shortcode-button");

			this.button.addEventListener("click", () => {
				this.onButtonClicked();
			});
		}
	}

	/**
	* When one of the inner buttons inside the main shortcode
	* button is clicked
	*/
	onButtonClicked(){
		RecentArticlesModal.showModal();
	}

	/**
	* Usually called from the modal's form when it's submitted.
	* Will inject the shortcode into the current editor
	* @param {int} numRecentArticles
	* @param {int} numColumns
	* @param {int[]} includedArticleCategories
	* @param {string|null} autofillArticles "on" or null
	*/
	injectShortcode(numRecentArticles, numColumns, includedArticleCategories, autofillArticles){
		includedArticleCategories = JSON.stringify(includedArticleCategories);
		autofillArticles = autofillArticles === "on" ? 1 : 0;
		const shortcodeText = `{{ get-recent-articles num-articles="${numRecentArticles}" columns="${numColumns}" included-article-categories="${includedArticleCategories}" autofill="${autofillArticles}" }}`
		EditorWrapper.insertTextAtCursor(shortcodeText);
		RecentArticlesModal.hideModal();
		EditorWrapper.focusEditor();
	}
}

export default (new RecentArticlesShortcodeButton);
