import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";
import RecentProjectsModal from "../modals/RecentProjectsModal.js";

class RecentProjectsShortcodeButton{
	constructor(){
		if (PageEditorStates.viewingState !== ""){
			this.button = document.querySelector("#recent-projects-shortcode-button");

			this.button.addEventListener("click", () => {
				this.onButtonClicked();
			});
		}
	}

	/**
	* When one of the inner buttons inside of the main shortcode
	* button is clicked
	* @param {Button} button HTML DOMNode
	*/
	onButtonClicked(button){
		RecentProjectsModal.showModal();
	}

	/**
	* Usually called from the modal's form when it's submitted.
	* Will inject the shortcode into the current editor
	* @param {int} numProjectsPerPage
	* @param {int} numColumns
	* @param {string[]} includedProjectTags
	* @param {string|null} autofillProjects "on" or null
	*/
	injectShortcode(numProjectsPerPage, numColumns, includedProjectTags, autofillProjects){
		includedProjectTags = JSON.stringify(includedProjectTags);
		autofillProjects = autofillProjects === "on" ? 1 : 0;
		const shortcodeText = `{{ get-recent-projects num-projects="${numProjectsPerPage}" columns="${numColumns}" included-project-tags="${includedProjectTags}" autofill="${autofillProjects}" }}`
		EditorWrapper.insertTextAtCursor(shortcodeText);
		RecentProjectsModal.hideModal();
		EditorWrapper.focusEditor();
	}
}

export default (new RecentProjectsShortcodeButton);
