import EditorWrapper from "../EditorWrapper.js";
import PageEditorStates from "../PageEditorStates.js";

class ReviewsShortcodeButton{
	constructor(){
		if (PageEditorStates.viewingState !== ""){
			this.button = document.querySelector("#reviews-shortcode-button");

			this.button.addEventListener("click", () => {
				this.onButtonClicked();
			});
		}
	}

	/**
	* When one of the inner buttons inside of the main shortcode
	* button is clicked
	* @param {Button} button HTML DOMNode
	*/
	onButtonClicked(button){
		this.injectShortcode();
	}

	/**
	* Usually called from the modal's form when it's submitted.
	* Will inject the shortcode into the current editor
	*/
	injectShortcode(){
		const shortcodeText = `{{ get-reviews columns="1" truncate-body="false" limit="100" offset="0" city="" state="" schema="true" show-empty-message="true" show-header="true" }}`
		EditorWrapper.insertTextAtCursor(shortcodeText);
		EditorWrapper.focusEditor();
	}
}

export default (new ReviewsShortcodeButton);
