import PageEditorStates from "../PageEditorStates.js";
import PageEditor from "../PageEditor.js";
import WindowManager from "../../../image-manager/WindowManager.js";

class ImageManagerButton{
	constructor(){
		this.button = document.querySelector("#upload-insert-image-button");

		if (this.button) {
			this.button.addEventListener("click", () => {
				this.onClick();
			});
		}
	}

	async onClick(){
		const imageManager = PageEditor.imageManager;
		// Set the current Ace editor in the ImageManager
		imageManager.setCurrentAceEditor(PageEditorStates.currentEditor.ace);

		// Only show the insert button in the image manager when the body or head editor
		// is active
		if (PageEditorStates.currentEditor !== null) {
			imageManager.imageManagerState.setImageMode(imageManager.imageManagerState.IMAGE_MODES.INSERT);
		}else{
			imageManager.imageManagerState.setImageMode(imageManager.imageManagerState.IMAGE_MODES.NONE);
		}

		imageManager.windowManager.show(WindowManager.WINDOWS.MAIN);
		/** @type {ImageComponent[]} */
		const imageComponents = await imageManager.imagesChosen;
		imageManager.windowManager.closeImageManager();

		if (imageComponents !== null){
			if (imageComponents.length > 0) {
				// A component was selected to insert
				PageEditorStates.currentEditor.insertImages(imageComponents);
			}
		}

	}
}

export default new ImageManagerButton();