import Result from "./components/Result.js";
import SearchForm from "./forms/SearchForm.js";
import ReplaceForm from "./forms/ReplaceForm.js";
import Scheduler from "../utils/Scheduler.js";

class FindAndReplace{

	replaceAllLoaderContainer = document.querySelector("#replacing-all-loader");
	mainAppContainer = document.querySelector("#main-application-container");
	replaceAllOccurrencesButton = document.querySelector("#replace-all-occurrences-button");
	isProcessingReplaceAll = false;

	constructor(){
		this.replaceAllOccurrencesButton.addEventListener("click", () => {
			this.replaceAllOccurrencesButtonClicked();
		});
	}

	async replaceAllOccurrencesButtonClicked(){
		if (this.isProcessingReplaceAll){
			return;
		}

		if (SearchForm.searchInputChangedSinceLastSubmission){
			alert("You have changed your search input since the last Find operation. You should re-run the Find operation before trying to make a replacement.");
			return;
		}

		this.isProcessingReplaceAll = true;
		this.replaceAllLoaderContainer.style.display = null;
		this.mainAppContainer.style.display = "none";

		// First, the array of results in the cache must be copied to another array
		// because the resultsCache array is modified after a find result item is removed
		// and the internal array iterator gets offset by the resultsCache array being spliced

		/** @type {Result[]} */
		const arrayOfResultObjects = [];

		for (const result of Result.resultsCache) {
			arrayOfResultObjects.push(result);
		}

		for (const result of arrayOfResultObjects){
			if (!result.isProcessing){
				await result.replaceAllOccurrenceButtonClicked();
			}
		}

		// Minimum wait time so the loader doesn't flash quickly
		await Scheduler.wait(330);

		this.isProcessingReplaceAll = false;
		this.replaceAllLoaderContainer.style.display = "none";
		this.mainAppContainer.style.display = null;
	}
}

export default new FindAndReplace();