import Result from "../components/Result.js";
import Scheduler from "../../utils/Scheduler.js";

class SearchForm{
	noResultsContainer = document.querySelector("#no-results-message-container");
	queryInput = document.querySelector("#query-input");
	replaceOccurrencesFormContainer = document.querySelector("#replace-form-container");
	loaderContainer = document.querySelector("#results-loader");
	form = document.querySelector("#search-form");
	isProcessing = false;
	/**
	 * Flag to determine if the query input field had changed since the last search - meaning the user
	 * has changed what is in the "query" box, but never actually re-ran a search operation.
	 * @type {boolean}
	 */
	searchInputChangedSinceLastSubmission = false;

	constructor() {
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});

		this.queryInput.addEventListener("input", () => {
			this.searchInputChangedSinceLastSubmission = true;
		});
	}

	async onSubmit(){

		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.noResultsContainer.style.display = "none";
		Result.clearAll();
		this.loaderContainer.style.display = null;
		this.replaceOccurrencesFormContainer.style.display = "none";
		this.searchInputChangedSinceLastSubmission = false;

		const fData = new FormData(this.form);
		const urlParams = new URLSearchParams();
		urlParams.set("query", fData.get("query"));

		const response = await fetch(`/uplift/find-and-replace/search?${urlParams.toString()}`, {
			method:"GET",
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data;
		try{
			/** @type {{status: int, error: ?string, results: Object[]}} **/
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			return;
		}

		// Force a wait time minimum
		await Scheduler.wait(330);

		if (data.status === 1){
			if (data.results.length > 0) {
				this.replaceOccurrencesFormContainer.style.display = null;
				for (const result of data.results) {
					new Result(result);
				}
			}else{
				this.noResultsContainer.style.display = null;
			}
		}else if (data.status === -1){

		}

		this.loaderContainer.style.display = "none";
		this.isProcessing = false;
	}
}

export default new SearchForm();