import NewGalleryButton from "./buttons/NewGalleryButton.js";
import NewGalleryModal from "./modals/NewGalleryModal.js";
import RenameGalleryModal from "./modals/RenameGalleryModal.js";
import NewGalleryForm from "./forms/NewGalleryForm.js";
import RenameGalleryForm from "./forms/RenameGalleryForm.js";
import Endpoints from "../Endpoints.js";
import GalleryRow from "./components/GalleryRow.js";
import Scheduler from "../utils/Scheduler.js";
import ImageManager from "../image-manager/ImageManager.js";
import ManageGalleryModal from "./modals/ManageGalleryModal.js";

class ImageGallery{

	/**
	 * @type {?ImageManager}
	 */
	imageManager = null;

	/**
	 * @type {ManageGalleryModal}
	 */
	manageGalleryModal;
	/**
	 * @type {RenameGalleryForm}
	 */
	renameGalleryForm;
	/**
	 * @type {NewGalleryForm}
	 */
	newGalleryForm;
	/**
	 * @type {RenameGalleryModal}
	 */
	renameGalleryModal;
	/**
	 * @type {NewGalleryButton}
	 */
	newGalleryButton;
	/**
	 * @type {NewGalleryModal}
	 */
	newGalleryModal;

	galleryLoader = document.querySelector("#gallery-loader");

	constructor() {
		this.loadImageManager();
		this.manageGalleryModal = new ManageGalleryModal(this);
		this.renameGalleryForm = new RenameGalleryForm(this);
		this.newGalleryForm = new NewGalleryForm(this);
		this.newGalleryModal = new NewGalleryModal(this);
		this.renameGalleryModal = new RenameGalleryModal(this);
		this.newGalleryButton = new NewGalleryButton(this);

		this.loadGalleries();
	}

	loadImageManager(){
		const imageManagerPermInput = document.querySelector("#has-image-manager-perms");
		if (imageManagerPermInput.value === "1"){
			this.imageManager = new ImageManager(document.querySelector("#image-manager-container"));
		}
	}

	async loadGalleries(){
		const galleries = await this.fetchGalleries();
		this.renderGalleries(galleries);
	}

	async fetchGalleries(){
		GalleryRow.clearRows();
		this.galleryLoader.style.display = null;
		const response = await fetch(Endpoints.galleries.fetchGalleries, {
			cache:"no-cache",
			credentials:"same-origin"
		});

		await Scheduler.wait(300);
		this.galleryLoader.style.display = "none";

		if (response.status === 200){
			/** @type {{status: int, error: ?string, galleries: array}} */
			const data = await response.json();
			if (data.status === 1){
				return data.galleries;
			}else if(data.status === -1){
				// TODO Error handle
			}
		}else{
			// TODO Error handle
		}

		return null;
	}

	/**
	 * @param {array} galleryObjects
	 */
	renderGalleries(galleryObjects){
		for (/** @type {{id: int, name: string, numImagesInGallery: int, creationTime: int}} */const gallery of galleryObjects){
			const row = new GalleryRow(gallery.id, gallery.name, gallery.numImagesInGallery, gallery.creationTime);
		}
	}
}

export default new ImageGallery();