let currentlyDraggedImageFrame;
let currentlyDraggedImageFrameOriginalParent;
let draggingPaddingLeft = 24;
let draggingPaddingTop = 24;
let currentGalleryID;

$(".gallery-modal-activator").on("click", function(){
	$("#active-gallery-id").val($(this).attr("data-gallery-id"));
	$("#gallery-modal-images-container").html("");
	$("#gallery-manager").modal("show");
	$("#gallery-modal-gallery-name").html($(this).find(".gallery-label").html());
	refreshGallery();
});

$("#gallery-modal-add-images-button").on("click", function(){
	$("#gallery-manager").on("hidden.bs.modal", function(){
		$(this).off("hidden.bs.modal");
		$("#image-manager").modal("show").trigger("mode-set", "multi-select");
		$("#image-manager").modal("show").trigger("refresh-contents");
	}).modal("hide");
});

/**
* Saves the positions of images in the gallery
*/
function saveImagePositions(){
	let imageDatas = [];
	$("#gallery-modal-images-container .gallery-image").each(function(position, element){
		imageDatas.push({
			"imageUri":element.getAttribute("data-imageuri"),
			"position":position
		});
	});
	$.post(
		$("#cms-install-directory").val() + "fbm-core/Controllers/ImageGallery/SaveImagePositionsInGallery.php",
		{"imageDatas":imageDatas, "gallery-id":currentGalleryID}
	);
}

function refreshGallery(){
	let gID = parseInt($("#active-gallery-id").val(), 10);
	$("#gallery-modal-loading-container").addClass("d-flex").removeClass("d-none");
	if (!isNaN(gID)){
		currentGalleryID = gID;
		$.get($("#cms-install-directory").val() + "fbm-core/Controllers/ImageGallery/GetImagesInGallery.php", {"gallery-id":gID}, function(r){
			$("#gallery-modal-loading-container").removeClass("d-flex").addClass("d-none");
			let images = r.images;
			let imageContainer = $("#gallery-modal-images-container");
			$.each(images, function(i, data){
				let template = $("#gallery-image-template").clone().removeAttr("id").show();
				template.find(".main-image").attr("src", data.thumbUri);
				template.find(".image-name").html(data.imageName);
				template.attr("data-imageuri", data.imageUri);
				imageContainer.append(template);

				template.find(".image-remove-handle").on("click", function(){
					template.remove();
					$.post(
						$("#cms-install-directory").val() + "fbm-core/Controllers/ImageGallery/RemoveImageFromGallery.php",
						{"gallery-id":gID, "imageUri":data.imageUri}
					);
				});

				template.find(".image-move-handle").on("mousedown", function(e){
					e.preventDefault();
					currentlyDraggedImageFrameOriginalParent = template.find(".image-frame").parent();
					currentlyDraggedImageFrame = template.find(".image-frame");
					currentlyDraggedImageFrame.addClass("dragging");
					let offset = $("#gallery-modal-images-container").offset();
					currentlyDraggedImageFrame.css({
						left:e.pageX - offset.left + draggingPaddingLeft,
						top:e.pageY - offset.top + draggingPaddingTop
					});
				});
			});
		});
	}
}

$(window).on("mousemove", function(e){
	if (currentlyDraggedImageFrame){
		let offset = $("#gallery-modal-images-container").offset();
		let newXPosition = e.pageX - offset.left + draggingPaddingLeft;
		let newYPosition = e.pageY - offset.top + draggingPaddingTop;
		currentlyDraggedImageFrame.css({
			left:newXPosition,
			top:newYPosition
		});

		let draggingMainContainer = currentlyDraggedImageFrameOriginalParent.closest(".gallery-image");
		let draggingMainContainer_Element = draggingMainContainer.get(0);
		let childrenArray = Array.from($("#gallery-modal-images-container").get(0).children);
		let indexOfDragger = childrenArray.indexOf(draggingMainContainer_Element);
		let currentDraggingOffset = currentlyDraggedImageFrame.offset();

		// Check the order of elements
		for (let i = 0; i < childrenArray.length; ++i){
			let currentElement = childrenArray[i];
			if (currentElement != draggingMainContainer_Element){
				let currentjQuery = $(currentElement);
				let currentElementPosition = currentjQuery.offset();

				if (i < indexOfDragger){
					// This element is before the dragger, is the dragger before it?
					if (currentDraggingOffset.left < currentElementPosition.left + 10){
						// The X is, but is the Y at least above the halfway point?
						let yThresholdToBeAbove = currentElementPosition.top + (currentjQuery.height()/2);
						let yThresholdToBeBelow = currentElementPosition.top - 10;
						if (currentDraggingOffset.top < yThresholdToBeAbove && currentDraggingOffset.top > yThresholdToBeBelow){
							// The dragging item needs to be placed before the currentElement
							$("#gallery-modal-images-container").get(0).insertBefore(draggingMainContainer_Element, currentElement);
							saveImagePositions();
							break;
						}
					}
				}else if (i > indexOfDragger){
					// This element is before the dragger, is the dragger before it?
					if (currentDraggingOffset.left > currentElementPosition.left + 10){
						// The X is, but is the Y at least above the halfway point?
						let yThresholdToBeAbove = currentElementPosition.top + (currentjQuery.height()/2);
						let yThresholdToBeBelow = currentElementPosition.top - 10;
						if (currentDraggingOffset.top < yThresholdToBeAbove && currentDraggingOffset.top > yThresholdToBeBelow){
							// The dragging item needs to be placed before the currentElement
							$("#gallery-modal-images-container").get(0).insertBefore(draggingMainContainer_Element, currentElement.nextSibling);
							saveImagePositions();
							break;
						}
					}
				}
			}
		}
	}
});

$(window).on("mouseup", function(e){
	if (currentlyDraggedImageFrame){
		currentlyDraggedImageFrame.appendTo(currentlyDraggedImageFrameOriginalParent).removeClass("dragging");
		currentlyDraggedImageFrame.css({
			left:0,
			top:0
		});
		currentlyDraggedImageFrame = undefined;
	}
});

$("#image-manager").on("multi-image-selected", function(e, images){
	// Add these images to the gallery
	// data-uri and data-thumburi
	let galleryID = parseInt($("#active-gallery-id").val(), 10);

	if (images.length > 0){
		let fData = new FormData();
		let imageCollection = [];
		fData.append("gallery-id", galleryID);

		$.each(images, function(i, elem){
			let imageUri = $(elem).attr("data-uri");
			let thumbUri = $(elem).attr("data-thumburi");
			imageCollection.push({
				"imageUri":imageUri,
				"thumbUri":thumbUri
			});
		});

		fData.append("images", JSON.stringify(imageCollection));

		$.ajax({
			url:$("#cms-install-directory").val() + "fbm-core/Controllers/ImageGallery/AddImagesToGallery.php",
			type:"post",
			data:fData,
			processData:false,
			cache:false,
			contentType:false,
			success:function(r){

			}
		});
	}
});

$("#new-gallery-form").on("submit", function(e){
	e.preventDefault();

	let submitButton = $("#new-gallery-submit-button");

	if (submitButton.hasClass("disabled")){
		return;
	}

	let submitError = $("#new-gallery-error");
	let formData = new FormData(this);
	submitButton.addClass("disabled");
	submitError.hide();

	$.ajax({
		type:"post",
		url:$("#cms-install-directory").val() + "fbm-core/Controllers/ImageGallery/CreateGallery.php",
		data:formData,
		contentType:false,
		processData:false,
		cache:false,
		success:function(r){
			if (typeof(r) == "object"){
				if (r.status == -1){
					submitButton.removeClass("disabled");
					submitError.show().html(r.error);
				}else if(r.status == 1){
					window.location.reload();
				}
			}
		}
	})
});

$("#rename-gallery-form").on("submit", function(e){
	e.preventDefault();

	let submitButton = $("#rename-gallery-submit-button");

	if (submitButton.hasClass("disabled")){
		return;
	}

	let submitError = $("#rename-gallery-error");
	let formData = new FormData(this);
	submitButton.addClass("disabled");
	submitError.hide();

	$.ajax({
		type:"post",
		url:$("#cms-install-directory").val() + "fbm-core/Controllers/ImageGallery/RenameGallery.php",
		data:formData,
		contentType:false,
		processData:false,
		cache:false,
		success:function(r){
			if (typeof(r) == "object"){
				if (r.status == -1){
					submitButton.removeClass("disabled");
					submitError.show().html(r.error);
				}else if(r.status == 1){
					window.location.reload();
				}
			}
		}
	})
});

$("#delete-gallery-form").on("submit", function(e){
	e.preventDefault();

	let submitButton = $("#delete-gallery-submit-button");

	if (submitButton.hasClass("disabled")){
		return;
	}

	let submitError = $("#delete-gallery-error");
	let formData = new FormData(this);
	submitButton.addClass("disabled");
	submitError.hide();

	$.ajax({
		type:"post",
		url:$("#cms-install-directory").val() + "fbm-core/Controllers/ImageGallery/DeleteGallery.php",
		data:formData,
		contentType:false,
		processData:false,
		cache:false,
		success:function(r){
			if (typeof(r) == "object"){
				if (r.status == -1){
					submitButton.removeClass("disabled");
					submitError.show().html(r.error);
				}else if(r.status == 1){
					window.location.reload();
				}
			}
		}
	})
});

$(".gallery-item").on("contextmenu", function(e){
	let currentItem = $(this);
	e.preventDefault();
	renderContextMenu(e.pageX, e.pageY, [
		{
			"label":"Rename",
			"onclick":function(){
				$("#rename-gallery-modal").modal("show");
				$("#rename-gallery-id").val(currentItem.find(".gallery-modal-activator").attr("data-gallery-id"));
				$("#rename-gallery-name").val(currentItem.find(".gallery-label").html()).trigger("paste");
			},
			"destroyOnClick":true
		},
		{
			"label":"Delete",
			"onclick":function(){
				$("#delete-gallery-modal").modal("show");
				$("#delete-gallery-id").val(currentItem.find(".gallery-modal-activator").attr("data-gallery-id"));
			},
			"destroyOnClick":true
		}
	])
})
