import SidebarFolderComponent from "./components/SidebarFolderComponent.js";
import ImageManagerState from "./ImageManagerState.js";

class DirectoriesFetcher{
	/**
	 * @type {?ImageManager}
	 */
	imageManager = null;
	isBusy = false;

	constructor(imageManager){
		this.imageManager = imageManager;
	}

	/**
	 * Fetches all directories in the system and renders them
	 */
	async fetchAndRender(){
		this.isBusy = true;

		// clear current folders
		this.imageManager.getSidebarFoldersContainer().innerHTML = "";

		const response = await fetch(`/uplift/image-manager/fetch-directories-recursively`, {
			credentials:"same-origin"
		});

		/** @type {{imagesDirectory:Object, error:?string, status:int}} */
		const data = await response.json();
		if (data.status === 1){
			/** @type {{fullDirectoryPath: string, childDirectories: Object[]}} */
			const imagesDirectory = data.imagesDirectory;

			// imagesDirectory is also the parent directory. Use this to set the ImageManagerState directory
			const baseStartDirectory = imagesDirectory.fullDirectoryPath;

			this.imageManager.imageManagerState.baseImagesDirectory = baseStartDirectory;
			if (this.imageManager.imageManagerState.currentDirectory === null){
				this.imageManager.imageManagerState.currentDirectory = baseStartDirectory;
			}

			// Render the childDirectories of this
			for (const childFolder of imagesDirectory.childDirectories){
				const component = new SidebarFolderComponent(this.imageManager, childFolder);
				component.getDOM();
				component.render();
			}
		}

		this.isBusy = false;
	}
}

export default DirectoriesFetcher;