import Endpoints from "../Endpoints.js";

class ImageMoveOperation {

	/**
	 *
	 * @param {string} imagePath
	 * @param {string} newDirectoryPath
	 * @param {ImageComponent} imageComponent
	 */
	constructor(imagePath, newDirectoryPath, imageComponent){
		this.imagePath = imagePath;
		this.newDirectoryPath = newDirectoryPath;

		/** @type {ImageComponent} */
		this.imageComponent = imageComponent;
	}

	async moveImageRequest(){
		const fData = new FormData();
		fData.set("imagePath", this.imagePath);
		fData.set("newDirectoryPath", this.newDirectoryPath);

		// By default, just don't allow overwrites
		fData.set("allowOverwrite", "0");

		const response = await fetch(`/uplift/image-manager/move-image`, {
			method:"PATCH",
			credentials:"same-origin",
			cache:"no-cache",
			body:fData
		});

		if (response.status === 200){
			let data;
			try {
				/** @type {{status:int, error:?string}} */
				data = await response.json();
			}catch(jsonSyntaxError){
				alert("Server returned invalid JSON.");
			}
			if (data.status === 1){
				// Delete the image item
				this.imageComponent.dom.remove();
			}
		}else{
			alert("Server returned a non-200 status code.");
		}
	}
}

export default ImageMoveOperation;