class MetaDataPane{
	/**
	 * @type {ImageManager}
	 */
	imageManager;

	/**
	 * @param {ImageManager} imageManager
	 */
	constructor(imageManager){
		this.imageManager = imageManager;
		this.pane = this.imageManager.container.querySelector(".img-meta-column");
		this.preview = this.imageManager.container.querySelector(".im-manager-preview");
		this.imageDataContainer = this.imageManager.container.querySelector(".img-info-container");
	}

	/**
	 * @param {string} src The image's source URI
	 */
	showPreview(src){
		this.preview.style.display = "block";
		this.preview.setAttribute("src", src + `?cache=${this.imageManager.imageManagerState.currentImageCacheRandomString}`);
	}

	/**
	 * @param {string} fileSize
	 * @param {string} fileType
	 * @param {?int} imageWidth
	 * @param {?int} imageHeight
	 */
	showImageData(fileSize, fileType, imageWidth, imageHeight){
		this.imageDataContainer.style.display = "block";
		document.querySelector("#im-file-size").textContent = fileSize;
		document.querySelector("#im-file-type").textContent = fileType;

		// For example, SVGs do not have set widths and heights
		if (imageWidth && imageHeight) {
			document.querySelector("#im-dimensions").parentElement.style.display = "block";
			document.querySelector("#im-dimensions").textContent = `${imageWidth}x${imageHeight}`;
		}else{
			document.querySelector("#im-dimensions").parentElement.style.display = "none";
		}
	}

	/**
	 * Shows the visual preview of an image
	 */
	hidePreview(){
		this.preview.style.display = "none";
	}

	/**
	 * Hides the textual metadata about a selected image
	 */
	hideImageData(){
		this.imageDataContainer.style.display = "none";
	}
}

export default MetaDataPane;