# Image Manager API
The image manager is an instantiable component-based system for use in Uplift.

## Adding It To a View
Import the image manager partial view on your view.

```php
include __DIR__ . "/path/to/views/partials/_partials/image-manager/_main.php";
```

Then, in your page's main JavaScript file import the image manager JS

```js
import ImageManager from "path/to/image/manager/js/folder/image-manager/ImageManager.js";
```

## API to Implement Image Manager
In your view's primary JavaScript where you have imported the ImageManager.js, you can then create an instance of the ImageManager.

```js
// By default the _main.php that is included via PHP has an image manager element with ID #image-manager-container
const imageManagerInstance = new ImageManager(document.querySelector("#image-manager-container"));
```

The ImageManager, if applicable, requires you to set the current Ace editor. **Note**: This method `setCurrentAceEditor()` is **not** what is used to insert the image HTML code when you double-click (or click Insert in the UI) an image. This method is **strictly** for using the "Make Quick Gallery" feature.

```js
imageManagerInstance.setCurrentAceEditor(aceEditor);
```

Next, you must set the image mode for the image manager. This determines if images will be able to be inserted via double-click or an Insert button appearing in the image manager UI.

```js
imageManagerInstance.imageManagerState.setImageMode(MODE);
```

Modes are available from the following
```js
imageManagerInstance.imageManagerState.IMAGE_MODES.INSERT
imageManagerInstance.imageManagerState.IMAGE_MODES.SELECT
imageManagerInstance.imageManagerState.IMAGE_MODES.NONE
```

So, to set the image manager to allow you to insert images, you would write:

```js
imageManagerInstance.imageManagerState.setImageMode(imageManagerInstance.imageManagerState.IMAGE_MODES.INSERT);
```

Finally, you can listen to the Promise `imagesChosen` which will fire when the image manager either has an image (or multiple images) chosen, or is closed. This will be `null` if the image manager is closed without any images chosen. Otherwise, it will be an array of ImageComponent objects. See the example below.

```js
/** @type {ImageComponent[]} */
const imageComponents = await imageManagerInstance.imagesChosen;

// Close the image manager when imagesChosen is fired
imageManager.windowManager.closeImageManager();

// Check if any images were chosen
if (imageComponents !== null){
	// Check if the array has members
    if (imageComponents.length > 0) {
        // imageComponents has ImageComponent objects. Do something with them (E.g., add them as <img> to an Ace editor)
    }
}
```

## Showing the Image Manager
After you have your image manager instance setup, you can then trigger it to show to the user by calling `show()` on the WindowManager and selecting the correct window (in this case, the MAIN window).
```js
imageManagerInstance.windowManager.show(WindowManager.WINDOWS.MAIN);
```