import MainWindow from "../windows/MainWindow.js";

class OSFileUploadComponent{
	/**
	 * @type {ImageManager}
	 */
	imageManager = null;

	/**
	 * @param {ImageManager} imageManager
	 */
	constructor(imageManager){
		this.imageManager = imageManager;
		this.input = imageManager.container.querySelector("#im-manager-os-file-upload");

		this.input.addEventListener("change", e => {
			this.onFileUploadInputChanged(e);
		});
	}

	/**
	 *
	 * @param {InputEvent} e
	 * @returns {Promise<void>}
	 */
	async onFileUploadInputChanged(e){
		const files = this.input.files;

		if (files.length > 0) {
			this.imageManager.windowManager.mainWindow.showUploadWindow();
			const errors = await this.imageManager.windowManager.mainWindow.uploadListOfFiles(files);
			await this.imageManager.windowManager.mainWindow.refreshCurrentLocation();
			this.imageManager.windowManager.mainWindow.hideUploadWindow();
			console.warn(errors);
		}
	}
}

export default OSFileUploadComponent;