class RefreshDirectoriesButton{
	/**
	 * @type {ImageManager}
	 */
	imageManager;
	button = null;

	/**
	 * @param {ImageManager} imageManager
	 */
	constructor(imageManager){
		this.imageManager = imageManager;
		this.button = this.imageManager.container.querySelector(".refresh-directories-button");

		this.button.addEventListener("click", () => {
			this.onClicked();
		});
	}


	onClicked(){
		if (!this.imageManager.directoriesFetcher.isBusy) {
			this.imageManager.directoriesFetcher.fetchAndRender();
		}
	}
}

export default RefreshDirectoriesButton;