class CompanyLogoPreview{
	/** @type {HTMLInputElement} */
	input = document.querySelector("#company-logo-input");
	previewImage = document.querySelector("#logo-preview");

	constructor() {
		this.input.addEventListener("change", /** @type {InputEvent} */ event => {
			this.onInputChange(event);
		});
	}

	/**
	 * @param {InputEvent} event
	 */
	onInputChange(event) {
		const files = this.input.files;
		if (files.length > 0){
			const file = files[0];
			const fileReader = new FileReader();
			fileReader.onload = () => {
				this.previewImage.src = fileReader.result;
			}

			fileReader.readAsDataURL(file);
		}
	}
}

export default new CompanyLogoPreview()