import Scheduler from "../../utils/Scheduler.js";
import Loader from "../components/Loader.js";
import Error from "../components/Error.js";
import InitialPageCheckboxes from "../components/InitialPageCheckboxes.js";
import MasterAccountPostLogin from "../components/MasterAccountPostLogin.js";

class InstallationForm{

	formContainer = document.querySelector("#installation-form-container");
	form = document.querySelector("#installation-form");
	isProcessing = false;

	constructor(){
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.formContainer.style.display = "none";
		Loader.show();

		const fData = new FormData(this.form);

		// Inject the selected initial pages, if any
		if (InitialPageCheckboxes.enableCheckbox.checked){
			const fileNames = [];
			for (const checkboxElement of document.querySelectorAll(".form-check-input-for-page")){
				if (checkboxElement.checked){
					fileNames.push(checkboxElement.getAttribute("data-filename"));
				}
			}

			fData.set("initial-page-filenames", JSON.stringify(fileNames));
		}


		const response = await fetch(`/uplift/install`, {
		    body:fData,
		    method:"POST",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		const clonedResponse = response.clone();
		try{
		    /** @type {{status: int, error: ?string}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
			const rawResponse = await clonedResponse.text();
			Error.message.textContent = `The server responded with invalid JSON. The response in raw text is shown below.\n\n${rawResponse}`;
			Loader.hide();
		    Error.show();
			this.isProcessing = false;
		    return;
		}

		// Minimum wait time to avoid flashing
		await Scheduler.wait(880);
		Loader.hide();

		if (data.status === 1){

			// Set Accelo company URL
			const acceloCompanyID = document.querySelector("#company-accelo-id-input").value.trim();
			document.querySelector("#accelo-company-url").setAttribute("href", `https://footbridgemedia.accelo.com/?action=view_company&id=${acceloCompanyID}`);

			MasterAccountPostLogin.show();
			MasterAccountPostLogin.usernameField.textContent = document.querySelector("#master-account-username-input").value.trim();
			MasterAccountPostLogin.clientUsernameField.textContent = document.querySelector("#client-account-username-input").value.trim();
			MasterAccountPostLogin.passwordField.textContent = document.querySelector("#master-account-password-input").value.trim();
			MasterAccountPostLogin.clientPasswordField.textContent = document.querySelector("#client-account-password-input").value.trim();
			this.formContainer.style.display = "none";

			await Scheduler.wait(2000);
			MasterAccountPostLogin.loginButton.classList.remove("disabled");
			MasterAccountPostLogin.loginButton.querySelector("span").textContent = "Login";
		}else if (data.status === -1){
			Error.show();
			Error.message.textContent = data.error;
		}

		this.isProcessing = false;
	}
}

export default new InstallationForm();