import Cookies from "../_external/js.cookie.js";
import Endpoints from "../Endpoints.js";

class LoginForm{
	constructor(){
		this.form = document.querySelector("#login-form");
		this.errorContainer = document.querySelector("#error");
		this.isSubmitting = false;

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	/**
	 * Fired when the form is submitted.
	 */
	async onSubmit(){
		if (this.isSubmitting){
			return;
		}

		this.isSubmitting = true;

		const fData = new FormData(this.form);
		const response = await fetch(Endpoints.login, {
			credentials:"same-origin",
			cache:"no-cache",
			body:fData,
			method:"post"
		});

		/** @type {{status: int, tokenName: string, token: string, expiresInDays: int, error: ?string}} */
		let data;
		try {
			data = await response.json();
		}catch(jsonSyntaxError) {
			this.errorContainer.style.display = "block";
			this.errorContainer.textContent = "There was a backend server error. Check the developer console's Network tab after trying again.";
			this.isSubmitting = false;
			return;
		}

		if (data.status === 1){
			const cookieName = data.tokenName;
			const token = data.token;
			const daysToExpire = data.expiresInDays;

			// Set the cookie for the login token
			Cookies.set(cookieName, token, {expires:daysToExpire});

			// Check if there is a redirect in the URL search params
			const searchParams = new URLSearchParams(window.location.search);
			if (searchParams.get("to") !== null){
				// Redirect there instead
				window.location.href = searchParams.get("to");
			}else {
				// Redirect to the main dashboard
				window.location.href = "/uplift/dashboard";
			}
		}else if (data.status === -1){
			// Known error
			const err = data.error;
			this.errorContainer.style.display = "block";
			this.errorContainer.textContent = err;
		}

		this.isSubmitting = false;
	}
}

export default new LoginForm();