import ConfirmModal from "../../utils/ConfirmModal.js";
import ManageRedirects from "../ManageRedirects.js";
import Endpoints from "../../Endpoints.js";
import EditRedirectModal from "../modals/EditRedirectModal.js";
import EditRedirectForm from "../forms/EditRedirectForm.js";

class Redirect{

	static redirectsContainer = document.querySelector("#redirects-rows-container");

	dom = null;
	isRegex;
	from;
	to;
	status;
	timestamp;
	preserveQueryString;

	/**
	 * @param {int} id
	 * @param {int} isRegex
	 * @param {string} from
	 * @param {string} to
	 * @param {int} status
	 * @param {int} timestamp
	 * @param {int} preserveQueryString
	 */
	constructor(id, isRegex, from, to, status, timestamp, preserveQueryString){
		this.id = id;
		this.isRegex = isRegex;
		this.from = from;
		this.to = to;
		this.status = status;
		this.timestamp = timestamp;
		this.preserveQueryString = preserveQueryString;
		this.dom = this.getDOM();

		Redirect.redirectsContainer.append(this.dom);
	}

	/**
	 * @returns {HTMLElement}
	 */
	getDOM(){

		// Set the icon HTML for regular expression symbolism
		let regexIcon = "";
		if (this.isRegex === 1){
			regexIcon = `<i class="text-success bi bi-check-circle-fill"></i>`;
		}else if (this.isRegex === 0){
			regexIcon = `<i class="text-danger bi bi-x-lg"></i>`;
		}

		// Set icon for preserving query string
		let preserveQueryStringIcon = "";
		if (this.preserveQueryString === 1){
			preserveQueryStringIcon = `<i class="text-success bi bi-check-circle-fill"></i>`;
		}else if (this.preserveQueryString === 0){
			preserveQueryStringIcon = `<i class="text-danger bi bi-x-lg"></i>`;
		}

		const dateString = (new Date(this.timestamp * 1000)).toLocaleDateString();

		const template = document.createElement("redirect-row");
		template.classList.add("redirect-columns");
		template.innerHTML = `
			<div class="regex">
				${regexIcon}
			</div>
			<div class="from">
				${this.from}
			</div>
			<div class="to">
				${this.to}			
			</div>
			<div class="status">
				${this.status}
			</div>
			<div class="preserve-query-string">
				${preserveQueryStringIcon}
			</div>
			<div class="timestamp">
				${dateString}
			</div>
			<div class="management-buttons">
				<button type="button" class="edit-redirect-button btn btn-sm btn-primary">
					<i class="bi bi-pencil-square"></i>
					<span>Edit</span>
				</button>
				<button type="button" class="delete-redirect-button btn btn-sm btn-danger">
					<i class="bi bi-trash-fill"></i>
				</button>
			</div>
		`;

		const deleteButton = template.querySelector(".delete-redirect-button");
		const editButton = template.querySelector(".edit-redirect-button");

		deleteButton.addEventListener("click", () => {
			this.onDelete();
		});


		editButton.addEventListener("click", () => {
			this.onEditButtonClicked();
		});

		return template;
	}

	onEditButtonClicked(){
		EditRedirectForm.currentRedirectID = this.id;
		EditRedirectModal.modal.querySelector("#edit-redirect-is-regex").checked = this.isRegex === 1;
		EditRedirectModal.modal.querySelector("#edit-redirect-from").value = this.from;
		EditRedirectModal.modal.querySelector("#edit-redirect-to").value = this.to;
		EditRedirectModal.modal.querySelector("#edit-redirect-status").value = this.status;
		EditRedirectModal.modal.querySelector("#edit-redirect-preserve-query-string").checked = this.preserveQueryString === 1;
		EditRedirectModal.showModal();
	}

	async onDelete(){
		const deleteModal = new ConfirmModal("remove-redirect-modal");
		deleteModal.setTitle("Delete this redirect");
		deleteModal.setContent("Are you sure you want to delete this redirect? If, after deletion, the page still redirects then clear your browser's cache. Optionally, you can use your browser's DevTools window and disable caching while that window is open.");
		deleteModal.setConfirmButtonText("Delete");
		deleteModal.showModal();
		const didConfirm = await deleteModal.actionTaken();
		deleteModal.cleanup();

		if (didConfirm){
			const response = await fetch(`${Endpoints.redirects.deleteRedirect}/${this.id}`, {
			    method:"DELETE",
			    cache:"no-cache",
			    credentials:"same-origin"
			});

			let data;
			try{
			    /** @type {{status: int, error: ?string}} **/
			    data = await response.json();
			}catch(jsonSyntaxError){
			    alert("The server responded with invalid JSON.");
			    return;
			}

			if (data.status === 1){
				ManageRedirects.loadRedirects(
					ManageRedirects.currentPage,
					ManageRedirects.currentLimit,
					ManageRedirects.currentQuery
				);
			}else if (data.status === -1){
				alert(data.error);
			}
		}
	}
}

export default Redirect;