import Endpoints from "../../Endpoints.js";
import NewRedirectModal from "../modals/NewRedirectModal.js";
import ManageRedirects from "../ManageRedirects.js";

class NewRedirectForm{
	form = document.querySelector("#new-redirect-form");
	isProcessing = false;

	constructor(){
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const response = await fetch(`${Endpoints.redirects.newRedirect}`, {
		    body:new FormData(this.form),
		    method:"PUT",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
			/** @type {{status: int, error: ?string}} */
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			return;
		}

		if (data.status === 1){
			this.form.reset();
			NewRedirectModal.hideModal();
			ManageRedirects.loadRedirects(
				ManageRedirects.currentPage,
				ManageRedirects.currentLimit,
				ManageRedirects.currentQuery
			);
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
	}
}

export default new NewRedirectForm();