import Endpoints from "../../Endpoints.js";
import NewReviewModal from "../modals/NewReviewModal.js";
import ManageReviews from "../ManageReviews.js";

class SearchReviewsForm{
	constructor(){
		this.isProcessing = false;
		this.form = document.querySelector("#review-search-form");

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const fData = new FormData(this.form);
		const query = fData.get("query");

		ManageReviews.currentPage = 1;
		ManageReviews.currentQuery = query;
		await ManageReviews.loadReviews(
			ManageReviews.currentPage,
			ManageReviews.currentLimit,
			ManageReviews.currentQuery
		);

		this.isProcessing = false;
	}
}

export default new SearchReviewsForm();