import BSModal from "../../_external/bootstrap/modal.js";
import RatingStars from "../components/RatingStars.js";

class EditReviewModal{

	currentReviewID = null;

	constructor(){
		this.modal = document.querySelector("#edit-review-modal");
		this.errorContainer = this.modal.querySelector("#edit-review-modal-error");
		this.errorMessageContainer = this.errorContainer.querySelector(".bg-danger");
		this.ratingInput = document.querySelector("#edit-review-rating");
		this.bsModal = new BSModal(this.modal);
		this.ratingStars = new RatingStars(document.querySelector("#edit-review-rating-stars"));

		// Set the rating input value when a star is selected
		this.ratingStars.onStarSelected(rating => {
			this.ratingInput.value = String(rating);
		});
	}

	/**
	* Forces the modal to be shown
	*/
	showModal(){
		this.bsModal.show();
	}

	/**
	* Forces the modal to be hidden
	*/
	hideModal(){
		this.bsModal.hide();
	}
}

export default new EditReviewModal();
