import Endpoints from "../../Endpoints.js";
import Scheduler from "../../utils/Scheduler.js";

class EditRoleForm {
	form = document.querySelector("#edit-role-form");
	roleID = parseInt(this.form.querySelector("#role-id").value);
	submitButton = document.querySelector("#edit-role-submit-button");
	isProcessing = false;

	constructor(){
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		this.submitButton.classList.add("disabled");
		this.submitButton.querySelector("span").textContent = "Saving...";

		const response = await fetch(`${Endpoints.roles.editRole}/${this.roleID}`, {
			body:new FormData(this.form),
			method:"PATCH",
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data;
		try{
			/** @type {{status: int, error: ?string}} */
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			return;
		}

		await Scheduler.wait(500);

		if (data.status === 1){

		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
		this.submitButton.classList.remove("disabled");
		this.submitButton.querySelector("span").textContent = "Save";
	}

	async onDelete(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const response = await fetch(`${Endpoints.roles.deleteRole}/${this.roleID}`, {
			body:new FormData(this.form),
			method:"DELETE",
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data;
		try{
			/** @type {{status: int, error: ?string}} */
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			this.isProcessing = false;
			return;
		}

		if (data.status === 1){
			window.location.href = "/uplift/manage-roles";
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
	}
}

export default new EditRoleForm();