import Endpoints from "../../Endpoints.js";
import NewRoleModal from "../modals/NewRoleModal.js";
import ManageRoles from "../Roles.js";

class NewRoleForm {
	form = document.querySelector("#new-role-form");
	isProcessing = false;

	constructor(){
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const response = await fetch(`${Endpoints.roles.newRole}`, {
			body:new FormData(this.form),
			method:"PUT",
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data;
		try{
			/** @type {{status: int, error: ?string}} */
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			return;
		}

		if (data.status === 1){
			this.form.reset();
			NewRoleModal.hideModal();
			await ManageRoles.loadRoles();
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
	}
}

export default new NewRoleForm();