import AceEditorExtension from "../editors/AceEditorExtension.js";
import Endpoints from "../Endpoints.js";
import NewSitemapForm from "./forms/NewSitemapForm.js";
import NewSitemapModal from "./modals/NewSitemapModal.js";
import Sitemap from "./components/Sitemap.js";
import Scheduler from "../utils/Scheduler.js";

class SitemapManager {
	newSitemapAceContainer = document.querySelector("#new-sitemap-content-editor");
	editSitemapAceContainer = document.querySelector("#edit-sitemap-content-editor");
	newSitemapAceEditor = ace.edit(this.newSitemapAceContainer);
	editSitemapAceEditor = ace.edit(this.editSitemapAceContainer);
	loader = document.querySelector("#sitemaps-loader");
	isProcessing = false;

	constructor(){
		// Load the ace editors
		new AceEditorExtension(this.newSitemapAceContainer, "xml");
		new AceEditorExtension(this.editSitemapAceContainer, "xml");

		this.loadSitemaps();
	}

	/**
	 * @returns {Promise<void>}
	 */
	async loadSitemaps() {
		if (this.isProcessing){
			return;
		}

		Sitemap.sitemapsContainer.innerHTML = "";

		this.isProcessing = true;
		this.loader.style.display = "block";

		const response = await fetch(`${Endpoints.sitemapManager.getSitemaps}`, {
			cache:"no-cache",
			credentials:"same-origin",
			method:"get",
		});

		await Scheduler.wait(150);

		let data;
		try{
			/** @type {{status: int, error: ?string, sitemaps: Object[]}} **/
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			return;
		}

		this.loader.style.display = "none";

		if (data.status === 1){
			for (const sitemap of data.sitemaps){
				new Sitemap(
					sitemap.id,
					sitemap.name,
					sitemap.route,
					sitemap.content,
					sitemap.contentType,
				);
			}
		}else if (data.status === -1){
			alert(data.error);
		}

		this.isProcessing = false;
	}
}

export default new SitemapManager();