import Endpoints from "../../Endpoints.js";
import EditSitemapModal from "../modals/EditSitemapModal.js";
import SitemapManager from "../SitemapManager.js";

class EditSitemapForm{
	constructor(){
		this.isProcessing = false;
		this.form = document.querySelector("#edit-sitemap-form");

		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;
		EditSitemapModal.errorContainer.style.display = "none";

		const fData = new FormData(this.form);
		// Send the new sitemap content from the "edit sitemap" ace editor
		fData.set("content", SitemapManager.editSitemapAceEditor.session.getValue());

		const response = await fetch(`${Endpoints.sitemapManager.editSitemap}/${EditSitemapModal.currentSitemapID}`, {
			credentials:"same-origin",
			cache:"no-cache",
			body:fData,
			method:"PATCH"
		});

		let data;
		try{
			data = await response.json();
		}catch(jsonSyntaxError){
			EditSitemapModal.errorContainer.style.display = "block";
			EditSitemapModal.errorMessageContainer.textContent = "The server sent back invalid JSON.";
			this.isProcessing = false;
			return;
		}

		if (data.status === 1){
			// Reload the current reviews page to reflect the changes
			SitemapManager.loadSitemaps();

			EditSitemapModal.hideModal();
			this.form.reset();
		}else if (data.status === -1){
			EditSitemapModal.errorContainer.style.display = "block";
			EditSitemapModal.errorMessageContainer.textContent = data.error;
		}

		this.isProcessing = false;
	}
}

export default new EditSitemapForm();