import NewAttributeButton from "./buttons/NewAttributeButton.js";
import NewAttributeForm from "./forms/NewAttributeForm.js";
import AttributeQueryForm from "./forms/AttributeQueryForm.js";
import PageAttribute from "./components/PageAttribute.js";

class ManagePageAttributes{

	loader = document.querySelector("#loader");
	noResults = document.querySelector("#no-results");
	table = document.querySelector("#page-attributes-table");
	isQuerying = false;

	constructor() {
		this.queryAttributes("", 1);
	}

	reloadCurrentAttributeQuery(){
		const query = AttributeQueryForm.getQueryInput();
		this.queryAttributes(query, AttributeQueryForm.pageNumber);
	}

	async queryAttributes(query, pageNumber){

		if (this.isQuerying){
			return;
		}

		this.isQuerying = true;
		this.loader.style.display = null;
		this.noResults.style.display = "none";
		PageAttribute.container.innerHTML = "";

		const urlParams = new URLSearchParams();
		urlParams.set("query", query);
		urlParams.set("pageNumber", pageNumber);

		const response = await fetch(`/uplift/page-attributes/query?${urlParams.toString()}`, {
		    body:null,
		    method:"GET",
		    cache:"no-cache",
		    credentials:"same-origin"
		});

		let data;
		try{
		    /** @type {{status: int, error: ?string, totalPages: int, attributes: Object[]}} **/
		    data = await response.json();
		}catch(jsonSyntaxError){
		    alert("The server responded with invalid JSON.");
			this.isQuerying = false;
			this.loader.style.display = "none";
		    return;
		}

		if (data.status === 1){
			if (data.attributes.length === 0){
				this.noResults.style.display = null;
			}else{
				for (const pageAttribute of data.attributes){
					const pageAttributeComponent = new PageAttribute(
						pageAttribute.id,
						pageAttribute.name,
						pageAttribute.pageTypes
					);

					pageAttributeComponent.render();
				}

				this.table.style.display = null;
			}
		}else if (data.status === -1){
			this.table.style.display = null;
		}

		this.isQuerying = false;
		this.loader.style.display = "none";
	}
}

export default new ManagePageAttributes();