import PageRestoration from "../PageRestoration.js";

class RestorationRow{

	/** @type {RestorationRow[]} */
	static cache = [];
	static container = document.querySelector("#results-container");

	id;
	pageID;
	pageName;
	creationTime
	dom;

	constructor(id, pageID, pageName, creationTime) {
		this.id = id;
		this.pageID = pageID;
		this.pageName = pageName;
		this.creationTime = creationTime;
		this.dom = this.getDOM();
		this.constructor.cache.push(this);
	}

	render(){
		RestorationRow.container.append(this.dom);
	}

	onRestoreButtonClicked(){
		this.restorePage();
	}

	async restorePage(){

		if (PageRestoration.isProcessing){
			return;
		}

		PageRestoration.isProcessing = true;

		const fData = new FormData();
		fData.set("archive-row-id", this.id);

		const response = await fetch(`/uplift/deleted-page-restoration/restore-page`, {
			body:fData,
			method:"POST",
			cache:"no-cache",
			credentials:"same-origin"
		});

		let data;
		try{
			/** @type {{status: int, error: ?string}} **/
			data = await response.json();
		}catch(jsonSyntaxError){
			alert("The server responded with invalid JSON.");
			PageRestoration.isProcessing = false;
			return;
		}

		if (data.status === 1){
			PageRestoration.isProcessing = false;
			await PageRestoration.loadRows(1, "");
		}else if (data.status === -1){
			PageRestoration.isProcessing = false;
		}

	}

	getDOM(){
		const template = document.createElement("tr");
		const creationDate = new Date(this.creationTime * 1000);
		const creationString = creationDate.toLocaleDateString();
		template.classList.add("page-restoration-result-row");
		template.classList.add("page-restoration-table-columns");
		template.innerHTML = `
			<td>
				<span>${this.id}</span>
			</td>
			<td>
				<span>${this.pageID}</span>
			</td>
			<td>
				<span>${this.pageName}</span>
			</td>
			<td>
				<span>${creationString}</span>
			</td>
			<td>
				<button type="button" class="restore-button btn btn-link py-0">
					<i class="bi bi-life-preserver"></i>
					<span>Restore Page</span>
				</button>
			</td>
		`;

		const restoreButton = template.querySelector(".restore-button");

		restoreButton.addEventListener("click", () => {
			this.onRestoreButtonClicked();
		});

		return template;
	}
}

export default RestorationRow;