import PageRestoration from "../PageRestoration.js";

class QueryForm{
	isProcessing = false;
	form = document.querySelector("#page-restoration-query-form");

	constructor() {
		this.form.addEventListener("submit", e => {
			e.preventDefault();
			this.onSubmit();
		});
	}

	async onSubmit(){
		if (this.isProcessing){
			return;
		}

		this.isProcessing = true;

		const fData = new FormData(this.form);
		await PageRestoration.loadRows(1, fData.get("query"))

		this.isProcessing = false;
	}
}

export default new QueryForm();