class AdminBar{

	static localStorageKeyName = "uplift-admin-bar-is-collapsed";

	barContainer = document.querySelector("public-front-end-admin-bar");
	openButton = document.querySelector("#public-front-end-admin-bar-toggle");
	hideButton = document.querySelector("#ucms-hide-bar");

	constructor() {

		if (this.barContainer !== null) {

			if (this.getIsCollapsedFromMemory()) {
				this.hide();
			} else {
				this.show();
			}

			this.openButton.addEventListener("click", () => {
				this.onOpenButtonClicked();
			});

			this.hideButton.addEventListener("click", () => {
				this.onHideButtonClicked();
			});

		}
	}

	onOpenButtonClicked(){
		this.show();
	}

	onHideButtonClicked(){
		this.hide();
	}

	/**
	 * Checks if the key that represents the admin bar being collapsed on page load exists. If it does, then the
	 * admin bar should start as collapsed.
	 * @returns {boolean}
	 */
	getIsCollapsedFromMemory(){
		return localStorage.getItem(this.constructor.localStorageKeyName) !== null;
	}

	show(){
		localStorage.removeItem(this.constructor.localStorageKeyName);
		this.barContainer.style.display = null;
		this.openButton.style.display = "none";
	}

	hide(){
		// When hidden, show the openButton
		localStorage.setItem(this.constructor.localStorageKeyName, "1");
		this.barContainer.style.display = "none";
		this.openButton.style.display = null;
	}
}

export default new AdminBar();