import PushHistoryFetcher from "./_history-fetcher.js";

(function(){
	let form = document.getElementById("push-form");
	let coreDirectory = document.getElementById("cms-install-directory").value;
	let errorContainer = document.getElementById("push-form-error");
	let successContainer = document.getElementById("push-success");
	let statusText = document.getElementById("status-text");
	let submitButton;

	for (let button of form.getElementsByTagName("button")){
		if (button.getAttribute("type") === "submit"){
			submitButton = button;
			break;
		}
	}

	form.addEventListener("submit", function(e){
		e.preventDefault();

		if (submitButton.classList.contains("disabled")){
			return;
		}

		statusText.innerHTML = "sending notification...";
		submitButton.classList.add("disabled");
		errorContainer.style.display = "none";
		successContainer.style.display = "none";

		fetch(coreDirectory + "fbm-core/Controllers/PushNotifications/SendMassNotification.php", {
			cache:"no-cache",
			credentials:"same-origin",
			method:"post",
			body:new FormData(form)
		}).then(function(response){
			response.json().then(function(rObject){
				submitButton.classList.remove("disabled");
				if (rObject.status === -1){
					errorContainer.style.display = "block";
					errorContainer.innerHTML = rObject.error;
					statusText.innerHTML = "send error";
				}else if (rObject.status === 1){
					// Success, refetch history
					successContainer.style.display = "block";
					successContainer.innerHTML = "Successfully sent to " + rObject.totalDevicesReached + " devices";
					PushHistoryFetcher.fetchPushHistory();
					statusText.innerHTML = "waiting...";

					// Reset the fields
					for (let control of document.getElementsByClassName("form-control")){
						control.value = "";
					}

					// After 5 seconds, hide the success container
					setTimeout(function(){
						successContainer.style.display = "none";
					}, 5000);
				}
			});
		});

	});

	PushHistoryFetcher.fetchPushHistory();
})();
